//	CFilePro.h

#ifndef _H_CFilePro
#define _H_CFilePro

#include "ProStructs.h"
#include "CFile.h"

class CFilePro : public CFile {
	
	public:
	
	OSErr		IFilePro(
		CDiskPro			*cDisk, 
		CFolderPro			*cParentFolderPro, 
		Pro_BlockNum		block, 
		Pro_EntryIndex		diskLocDirEntryIndex,	//	relative to cur dir sector
		Pro_EntryIndex		directoryIndex);		//	relative to entire directory
		
	Pro_DirEntry		*GetMyEntry(void);
	OSErr				FlushEntry(void);
	
	virtual	Boolean		IsForked(void);
	virtual	OSErr		GetForkInfo(CCT_ForkInfo *forkInfoP);
	virtual	OSErr		SetForkInfo(CCT_ForkInfo *forkInfoP);

	virtual	ushort		GetLoadAddress(void);
	virtual	void		SetLoadAddress(ushort address);
	
	virtual char		*GetDescription(char *buf);

	virtual ulong		GetPhysicalSize(void);
	virtual ulong		GetLogicalSize(void);

	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	void			SetCreatedTime(DateTimeRec *dt);
	virtual	void			SetModifiedTime(DateTimeRec *dt);
	virtual	void			SetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate);
	virtual	void			GetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate);

	virtual	char		*GetName(char *buf);
	virtual	void		SetName(char *buf);
	virtual	OSErr 		ReadFile(Byte *buffer, long length);
	virtual	OSErr 		WriteFile(Byte *buffer, long length);
	virtual ADFS_IconType		GetIconType(void);
	
	virtual	void		SetFileType_ProEquiv(Byte proType);
	virtual	ushort		GetFileType_ProEquiv(void);
	
	virtual	void		SetFileType(Byte fileType);
	virtual	ushort		GetFileType(void);

	virtual	ushort		GetAuxType(void);
	virtual	void		SetAuxType(ushort auxType);

	virtual	void		GetAccessBits(Gen_AccessBits *bits);
	virtual	void		SetAccessBits(Gen_AccessBits *bits);
	virtual	void		SetFileAndAuxType(Byte fileType, ushort auxType);

	OSErr				Pro_GetIndBlockNumR(
		Pro_StorageType		storageType, 
		Pro_BlockNum		keyBlockNum, 
		Pro_BlockNum		blockIndex, 
		Pro_BlockNum		*blockNum);

	virtual	OSErr		Pro_GetIndBlockNum(
		Pro_BlockNum blockIndex, 
		Pro_BlockNum *blockNum);

	virtual	ulong		ADFS_GetBufSize(void);
	virtual	OSErr		ADFS_Open(
		ADFS_IOType	ioType, 
		Boolean		resForkB, 
		char		**bufferP, 
		ulong		*bufSize);

	virtual	OSErr		ADFS_Read(ushort *bytesRead);
	virtual	OSErr		ADFS_Write(ushort *bytesWritten);
	virtual	OSErr		ADFS_Close(void);

	OSErr	Pro_WriteBlock(
		ushort			numBytesS, 
		Pro_Block		*block);

	virtual	char		*GetStorageStr(char *buf256);
	
	OSErr			GetFileBlocks(
		Pro_BlockNum	startBlockS, 
		ushort			storageType, 
		Pro_BlockNum	*fileBlockA0, 
		Pro_BlockNum	*numFileBlocksSP, 
		Pro_BlockNum	*extentBlockA0, 
		Pro_BlockNum	*numExtentBlocksSP);

	Pro_StorageType		GetStorageType(Pro_DirEntry *entryP0 = NULL);

	virtual	OSErr		GetEntryAlloc(
		Boolean			getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	virtual	Boolean		IsDeleted(void);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	Boolean		HasCustomIcon(void);
	void		DrawIcon(IconTransformType transform, Rect *theRect);

	private:
	
	//	used when writing res fork of forked file
	Pro_ForkEntry		i_dataForkEntry;
	Pro_DirEntry		i_myEntry;

	typedef CFile _inherited;
};

#endif
